unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
function UltimoAcesso(Arquivo : String) : TDateTime;
var
  Win32FindData: TWin32FindData;
  FileTime : TFileTime;
  SystemTime : TSystemTime;
  Handle : THandle;
begin
// pega informao do arquivo
  Handle := Windows.FindFirstFile(PChar(Arquivo),
     Win32FindData);
  if Handle <> INVALID_HANDLE_VALUE then begin
// converte o ltimo acesso para hora local
    FileTimeToLocalFileTime(
       Win32FindData.ftLastAccessTime, FileTime);
// converte para SystemTime
    FileTimeToSystemTime(FileTime, SystemTime);
// converte para TDateTime    
    with SystemTime do
      Result := EncodeDate(wYear,wMonth,wDay)+EncodeTime(wHour,wMinute,wSecond,wMilliseconds);
    Windows.FindClose(Handle);
  end
  else
    raise EInOutError.Create('Arquivo invlido');
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if Edit1.Text <> '' then
    ShowMessage(FormatDateTime('dd/mm/yyyy hh:nn:ss',UltimoAcesso(Edit1.Text)));
end;

end.
